/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.ccfw.mom.PIFrame;
import com.ibm.hsc.ccfw.pa.util.PAHscEventHandler;
import com.ibm.hsc.ccfw.pa.util.PAHscEventListener;
import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.cim.client.pi.PIHSCFrameCIMClient;
import com.ibm.hsc.cim.client.pi.PIHscSysCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.websm.updates.PIUpdateDefines;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class TargettedFsp
implements PAHscEventListener,
PIUpdateErrorIds,
PIUpdateDefines {
    public static final int NOT_N_MODE_POWER = 0;
    public static final int N_MODE_POWER = 1;
    public static final int ACDL_PENDING = 2;
    private static final String TRACE_MASKT = "XUPDFSPT";
    private static final String TRACE_MASKF = "XUPDFSPF";
    private static final String TRACE_MASKD = "XUPDFSPD";
    private static final UnsignedInt8 notConnectedState = new UnsignedInt8(254);
    private Integer acdlFailed = new Integer(3);
    private Integer acdlLock = new Integer(0);
    private Integer acdlNotDone = new Integer(99);
    private Integer acdlPhase;
    private Integer acdlReturnCode;
    private String acdlSide;
    private boolean backupDisconnected;
    private Integer backupRebootLock = new Integer(0);
    private PIHSCCECCIMClient beanProvider;
    private PIHscSysCIMClient cecProvider;
    private boolean connectionObjectSubscription;
    private PIUpdater currentUpdater;
    private boolean doesFrameFSPHaveSlave;
    private PIFrame frame;
    private PIHSCFrameCIMClient frameProvider;
    private boolean frameOnA;
    private int frusToLoad;
    private boolean fspForBpa;
    private PAHscEventHandler heHandler = null;
    private UnsignedInt8 lastState;
    private String mtms;
    private boolean primaryDisconnected;
    private boolean rebootDone;
    private Integer rebootLock = new Integer(0);
    private boolean runningAcdl;
    protected Integer slaveUpdateLock = new Integer(0);
    private boolean waitingOnPrimary;
    private boolean waitingOnBackup;
    protected Integer writeSlaveReturnCode;

    public TargettedFsp(String string) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> TargettedFsp()");
        this.initTargettedFsp(string, true);
        Trace.trace((String)TRACE_MASKT, (Object)"<- TargettedFsp()");
    }

    public TargettedFsp(String string, PIFrame pIFrame) throws HException {
        int n;
        StackTraceElement[] stackTraceElementArray;
        Trace.trace((String)TRACE_MASKT, (Object)"-> TargettedFsp()");
        this.initTargettedFsp(string, false);
        this.frame = pIFrame;
        try {
            Trace.trace((String)TRACE_MASKF, (Object)"Calling getActiveSide.");
            this.frameOnA = this.frame.getActiveSide();
        }
        catch (Throwable throwable) {
            Trace.trace((String)TRACE_MASKF, (Object)"Printing out stack trace.");
            stackTraceElementArray = throwable.getStackTrace();
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                Trace.trace((String)TRACE_MASKF, (Object)stackTraceElementArray[n].toString());
            }
            this.frameOnA = true;
        }
        this.doesFrameFSPHaveSlave = true;
        try {
            this.doesFrameFSPHaveSlave = pIFrame.isSlaveFSPExists();
            Trace.trace((String)TRACE_MASKF, (Object)("this.doesFrameFSPHaveSlave=" + (this.doesFrameFSPHaveSlave ? "true" : "false")));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Attempt to query for slave FSP returned an exception [" + exception + "]"));
            stackTraceElementArray = exception.getStackTrace();
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                Trace.trace((String)TRACE_MASKF, (Object)stackTraceElementArray[n].toString());
            }
        }
        this.frusToLoad = 2;
        Trace.trace((String)TRACE_MASKF, (Object)("this.frameOnA is " + (this.frameOnA ? "true" : "false")));
        Trace.trace((String)TRACE_MASKT, (Object)"<- TargettedFsp()");
    }

    public void codeUpdateComplete(String string, short s) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.codeUpdateComplete(string, s);
    }

    public void commitCodeUpdate(String string, short s) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.commitCodeUpdate(string, s);
    }

    public void deactivateBpa() throws PIUpdateException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> deactivateBpa");
        if (this.fspForBpa) {
            String string = this.mtms.substring(0, 4);
            String string2 = this.mtms.substring(5, 8);
            String string3 = this.mtms.substring(9);
            String string4 = "U" + string + "." + string2 + "." + string3;
            Trace.trace((String)TRACE_MASKF, (Object)("deactivating Bpa at :" + string4));
            try {
                Object object;
                LocalizableText[] localizableTextArray;
                boolean bl = this.frame.getActiveSide();
                Integer n = new Integer(0);
                Integer n2 = null;
                Integer n3 = null;
                if (this.isBpaFspRedundant()) {
                    if (bl) {
                        localizableTextArray = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P1-C4");
                        n2 = (Integer)localizableTextArray.get("ReturnCode");
                        n3 = (Integer)localizableTextArray.get("ErrorData");
                        if (n2.equals(n)) {
                            object = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P2-C4");
                            n2 = (Integer)((Hashtable)object).get("ReturnCode");
                            n3 = (Integer)((Hashtable)object).get("ErrorData");
                        }
                    } else {
                        localizableTextArray = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P2-C4");
                        n2 = (Integer)localizableTextArray.get("ReturnCode");
                        n3 = (Integer)localizableTextArray.get("ErrorData");
                        if (n2.equals(n)) {
                            object = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P1-C4");
                            n2 = (Integer)((Hashtable)object).get("ReturnCode");
                            n3 = (Integer)((Hashtable)object).get("ErrorData");
                        }
                    }
                } else if (bl) {
                    localizableTextArray = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P1-C4");
                    n2 = (Integer)localizableTextArray.get("ReturnCode");
                    n3 = (Integer)localizableTextArray.get("ErrorData");
                } else {
                    localizableTextArray = this.frameProvider.bpaFruLevelDeactivate(string4 + "-P2-C4");
                    n2 = (Integer)localizableTextArray.get("ReturnCode");
                    n3 = (Integer)localizableTextArray.get("ErrorData");
                }
                if (!n2.equals(n)) {
                    localizableTextArray = new LocalizableText[]{new LocalizableText(this.mtms)};
                    object = new PIUpdateException(-1763, "Deactivate BPA " + this.mtms + " failed, ReturnCode=" + n2 + " ErrorData=" + n3, localizableTextArray);
                    throw object;
                }
            }
            catch (PIHscClientException pIHscClientException) {
                LocalizableText[] localizableTextArray = new LocalizableText[]{new LocalizableText(this.mtms)};
                PIUpdateException pIUpdateException = new PIUpdateException(-1761, pIHscClientException, localizableTextArray);
                throw pIUpdateException;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- deactivateBpa");
    }

    public String getBpaSide(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getBpaSide");
        String string2 = "SIDE_A";
        if (string.equals("SIDE_A") || string.equals("SIDE_B")) {
            Trace.trace((String)TRACE_MASKF, (Object)"Side info already translated to BPC.");
            string2 = string;
        } else {
            if (string.equals("slave")) {
                string2 = "SIDE_B";
            }
            this.frameOnA = this.frame.getActiveSide();
            Trace.trace((String)TRACE_MASKF, (Object)("this.frameOnA is " + (this.frameOnA ? "true" : "false")));
            if (!this.frameOnA) {
                Trace.trace((String)TRACE_MASKF, (Object)"We are not on the A side");
                string2 = string.equals("slave") ? "SIDE_A" : "SIDE_B";
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- getBpaSide(" + string2 + ")"));
        return string2;
    }

    public Vector getCodeUpdateStatus(String string) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        return this.cecProvider.getCodeUpdateStatus(string);
    }

    public Vector getFirmwareUpdateStatus(String string) throws PIHscClientException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getFirmwareUpdateStatus()");
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        Vector vector = null;
        try {
            Trace.trace((String)TRACE_MASKD, (Object)("Calling getFirmwareUpdateStatus this.beanProvider=" + this.beanProvider));
            vector = this.beanProvider.getFirmwareUpdateStatus(string);
            Trace.trace((String)TRACE_MASKD, (Object)"getFirmwareUpdateStatus returned");
        }
        catch (Throwable throwable) {
            Trace.trace((String)TRACE_MASKF, (Object)"Printing out stack trace.");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                Trace.trace((String)TRACE_MASKF, (Object)stackTraceElementArray[i].toString());
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- getFirmwareUpdateStatus()");
        return vector;
    }

    public String getMTMS() {
        Trace.trace((String)TRACE_MASKT, (Object)("<> getMTMS() returns [" + this.mtms + "]"));
        String string = this.mtms;
        return string;
    }

    public UnsignedInt8 getState() throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getState()");
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
        if (this.fspForBpa) {
            try {
                String[] stringArray = new String[]{"state"};
                Trace.trace((String)TRACE_MASKF, (Object)"Calling getFrameDataBean");
                PIFrameDataBean pIFrameDataBean = this.frameProvider.getFrameDataBean(stringArray);
                unsignedInt8 = pIFrameDataBean.getState();
            }
            catch (Throwable throwable) {
                Trace.trace((String)TRACE_MASKF, (Object)("getFrameDataBean failed" + throwable));
                PIUpdateException pIUpdateException = new PIUpdateException(-1766, throwable);
                new UnsignedInt8(3);
                Trace.trace((String)TRACE_MASKF, (Object)"Printing out stack trace.");
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    Trace.trace((String)TRACE_MASKF, (Object)stackTraceElementArray[i].toString());
                }
            }
        } else {
            try {
                PIHSCCECCIMClient pIHSCCECCIMClient = PIUpdatesOwner.createFspClient(this.mtms);
                if (pIHSCCECCIMClient == null) {
                    unsignedInt8 = notConnectedState;
                } else {
                    this.beanProvider = pIHSCCECCIMClient;
                    String[] stringArray = new String[]{"state"};
                    PICECDataBean pICECDataBean = this.beanProvider.getCECDataBean(stringArray);
                    unsignedInt8 = pICECDataBean.getCecState();
                }
            }
            catch (PIHscClientException pIHscClientException) {
                Trace.trace((String)TRACE_MASKF, (Object)("getCECDataBean failed" + pIHscClientException));
                PIUpdateException pIUpdateException = new PIUpdateException(-2026, pIHscClientException);
                throw pIUpdateException;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- getState(" + unsignedInt8 + ")"));
        return unsignedInt8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hscEventOccured(HSCEvent hSCEvent) {
        CIMProperty cIMProperty;
        Object object;
        String string;
        Object object2;
        Object object3;
        int n;
        block76: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> hscEventOccured()");
            Trace.trace((String)TRACE_MASKD, (Object)("this.mtms=[" + this.mtms + "]"));
            Trace.trace((String)TRACE_MASKD, (Object)("key: " + hSCEvent.getEventKey()));
            n = hSCEvent.getEventType();
            if (n == 305) {
                Trace.trace((String)TRACE_MASKF, (Object)"Got ACDL status change asynch event");
                if (this.runningAcdl) {
                    try {
                        boolean bl = false;
                        object3 = hSCEvent.getNewObject();
                        object2 = object3.getClass();
                        string = ((Class)object2).getName();
                        Trace.trace((String)TRACE_MASKD, (Object)("getNewObject returned a class [" + string + "]"));
                        if (object3 instanceof CIMInstance) {
                            object = (CIMInstance)object3;
                            Trace.trace((String)TRACE_MASKD, (Object)"Checking SystemStatusProgress");
                            cIMProperty = object.getProperty("SystemStatusProgress");
                            if (cIMProperty != null) {
                                Trace.trace((String)TRACE_MASKD, (Object)("prop=[" + cIMProperty + "]"));
                            }
                        }
                        if (object3 instanceof Hashtable) {
                            object = (Hashtable)object3;
                            bl = this.areFrusDone((Hashtable)object);
                        } else {
                            bl = this.checkFrusDone();
                        }
                        if (!bl) break block76;
                        if (this.acdlReturnCode.equals(this.acdlNotDone)) {
                            this.acdlReturnCode = new Integer(0);
                        }
                        object = this.acdlLock;
                        synchronized (object) {
                            this.runningAcdl = false;
                            Trace.trace((String)TRACE_MASKD, (Object)"ACDL is done. Call notify.");
                            this.acdlLock.notify();
                        }
                    }
                    catch (HException hException) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Got an exception trying to check where ACDL completed all FRUs.");
                    }
                }
            }
        }
        if (n == 4) {
            String string2 = hSCEvent.getObjectType();
            Trace.trace((String)TRACE_MASKD, (Object)("objectType=[" + string2 + "]"));
            if (string2.equals("IBMHSC_Connection")) {
                object3 = hSCEvent.getNewObject();
                object2 = object3.getClass();
                string = ((Class)object2).getName();
                Trace.trace((String)TRACE_MASKD, (Object)("getNewObject returned a class [" + string + "]"));
                if (object3 instanceof CIMInstance && (cIMProperty = (object = (CIMInstance)object3).getProperty("ConnectionState")) != null) {
                    Trace.trace((String)TRACE_MASKD, (Object)("stateProp=[" + cIMProperty + "]"));
                    CIMValue cIMValue = cIMProperty.getValue();
                    if (cIMValue != null) {
                        Trace.trace((String)TRACE_MASKD, (Object)("stateVal=[" + cIMValue + "]"));
                        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                        if (unsignedInt16 != null) {
                            Trace.trace((String)TRACE_MASKD, (Object)("connState=[" + unsignedInt16 + "]"));
                            Trace.trace((String)TRACE_MASKD, (Object)"Checking LocationCode");
                            CIMProperty cIMProperty2 = object.getProperty("LocationCode");
                            if (cIMProperty2 != null) {
                                Trace.trace((String)TRACE_MASKD, (Object)("prop=[" + cIMProperty2 + "]"));
                                CIMValue cIMValue2 = cIMProperty2.getValue();
                                if (cIMValue2 != null) {
                                    Trace.trace((String)TRACE_MASKD, (Object)("cimVal=[" + cIMValue2 + "]"));
                                    String string3 = (String)cIMValue2.getValue();
                                    if (string3 != null) {
                                        Integer n2;
                                        if (string3.equalsIgnoreCase("SECONDARY")) {
                                            if (unsignedInt16.intValue() == 0) {
                                                Trace.trace((String)TRACE_MASKF, (Object)"Backup CEC FSP connected");
                                                if (this.waitingOnBackup && !this.fspForBpa && this.backupDisconnected) {
                                                    this.rebootDone = true;
                                                    n2 = this.backupRebootLock;
                                                    synchronized (n2) {
                                                        Trace.trace((String)TRACE_MASKF, (Object)"Setting the backupRebootLock");
                                                        this.backupRebootLock.notify();
                                                    }
                                                }
                                            } else {
                                                Trace.trace((String)TRACE_MASKF, (Object)"Backup CEC FSP disconnected");
                                                this.backupDisconnected = true;
                                            }
                                        }
                                        if (string3.equalsIgnoreCase("PRIMARY")) {
                                            if (unsignedInt16.intValue() == 0) {
                                                Trace.trace((String)TRACE_MASKF, (Object)"Primary CEC FSP connected");
                                                if (this.waitingOnPrimary && !this.fspForBpa && this.primaryDisconnected) {
                                                    this.rebootDone = true;
                                                    n2 = this.rebootLock;
                                                    synchronized (n2) {
                                                        Trace.trace((String)TRACE_MASKF, (Object)"Setting the rebootLock");
                                                        this.rebootLock.notify();
                                                    }
                                                }
                                            } else {
                                                Trace.trace((String)TRACE_MASKF, (Object)"Primary CEC FSP disconnected");
                                                this.primaryDisconnected = true;
                                            }
                                        }
                                        if (string3.equalsIgnoreCase("SIDE_A")) {
                                            Trace.trace((String)TRACE_MASKF, (Object)("Side A connection state = " + unsignedInt16.intValue() + " this.frameOnA=" + this.frameOnA));
                                            if (this.fspForBpa) {
                                                if (this.frameOnA) {
                                                    if (unsignedInt16.intValue() == 0) {
                                                        if (this.waitingOnPrimary && this.primaryDisconnected) {
                                                            this.rebootDone = true;
                                                            n2 = this.rebootLock;
                                                            synchronized (n2) {
                                                                Trace.trace((String)TRACE_MASKF, (Object)"Setting the rebootLock");
                                                                this.rebootLock.notify();
                                                            }
                                                        }
                                                    } else {
                                                        Trace.trace((String)TRACE_MASKF, (Object)"Primary BPC FSP disconnected");
                                                        this.primaryDisconnected = true;
                                                    }
                                                } else if (unsignedInt16.intValue() == 0) {
                                                    if (this.waitingOnBackup && this.backupDisconnected) {
                                                        this.rebootDone = true;
                                                        n2 = this.backupRebootLock;
                                                        synchronized (n2) {
                                                            Trace.trace((String)TRACE_MASKF, (Object)"Setting the backupRebootLock");
                                                            this.backupRebootLock.notify();
                                                        }
                                                    }
                                                } else {
                                                    Trace.trace((String)TRACE_MASKF, (Object)"Backup BPC FSP disconnected");
                                                    this.backupDisconnected = true;
                                                }
                                            }
                                        }
                                        if (string3.equalsIgnoreCase("SIDE_B")) {
                                            Trace.trace((String)TRACE_MASKF, (Object)("Side B connection state = " + unsignedInt16.intValue() + " this.frameOnA=" + this.frameOnA));
                                            if (this.fspForBpa) {
                                                if (!this.frameOnA) {
                                                    if (unsignedInt16.intValue() == 0) {
                                                        if (this.waitingOnPrimary && this.primaryDisconnected) {
                                                            this.rebootDone = true;
                                                            n2 = this.rebootLock;
                                                            synchronized (n2) {
                                                                Trace.trace((String)TRACE_MASKF, (Object)"Setting the rebootLock");
                                                                this.rebootLock.notify();
                                                            }
                                                        }
                                                    } else {
                                                        Trace.trace((String)TRACE_MASKF, (Object)"Primary BPC FSP disconnected");
                                                        this.primaryDisconnected = true;
                                                    }
                                                } else if (unsignedInt16.intValue() == 0) {
                                                    if (this.waitingOnBackup && this.backupDisconnected) {
                                                        this.rebootDone = true;
                                                        n2 = this.backupRebootLock;
                                                        synchronized (n2) {
                                                            Trace.trace((String)TRACE_MASKF, (Object)"Setting the backupRebootLock");
                                                            this.backupRebootLock.notify();
                                                        }
                                                    }
                                                } else {
                                                    Trace.trace((String)TRACE_MASKF, (Object)"Backup BPC FSP disconnected");
                                                    this.backupDisconnected = true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                try {
                    object3 = this.getState();
                    Trace.trace((String)TRACE_MASKF, (Object)("Got an event modify object lastState=" + this.lastState + " currentState=" + object3));
                    if (this.lastState.equals((Object)notConnectedState)) {
                        if (!object3.equals((Object)notConnectedState)) {
                            Trace.trace((String)TRACE_MASKF, (Object)("The reboot of FSP [" + this.mtms + "] has completed."));
                            this.rebootDone = true;
                            if (this.fspForBpa) {
                                this.frameOnA = this.frame.getActiveSide();
                                Trace.trace((String)TRACE_MASKF, (Object)("this.frameOnA is " + (this.frameOnA ? "true" : "false")));
                            }
                            object2 = this.rebootLock;
                            synchronized (object2) {
                                Trace.trace((String)TRACE_MASKF, (Object)"Setting the rebootLock");
                                this.rebootLock.notify();
                            }
                        }
                    }
                    this.lastState = object3;
                }
                catch (HException hException) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Got exception trying to read state information during asynch.");
                    object2 = new PIUpdateException(-1765, hException);
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- hscEventOccured()");
    }

    public boolean isForBpa() {
        Trace.trace((String)TRACE_MASKT, (Object)("<> isForBpa() returns " + (this.fspForBpa ? "true" : "false")));
        return this.fspForBpa;
    }

    public boolean isBpaFspRedundant() {
        this.doesFrameFSPHaveSlave = this.frame.isSlaveFSPExists();
        Trace.trace((String)TRACE_MASKT, (Object)("<> isBpaFspredundant() returns " + (this.doesFrameFSPHaveSlave ? "true" : "false")));
        return this.doesFrameFSPHaveSlave;
    }

    public int isNModePower(boolean bl) throws PIUpdateException {
        int n = this.isNModePower(bl, "SIDE_A");
        if (n == 0 && this.doesFrameFSPHaveSlave) {
            n = this.isNModePower(bl, "SIDE_B");
        }
        return n;
    }

    public int isNModePower(boolean bl, String string) throws PIUpdateException {
        Object object;
        LocalizableText[] localizableTextArray;
        Trace.trace((String)TRACE_MASKT, (Object)"-> isNModePower()");
        int n = 99;
        boolean bl2 = true;
        boolean bl3 = true;
        Short s = new Short(0);
        Short s2 = new Short(4);
        Short s3 = new Short(5);
        Short s4 = new Short(6);
        try {
            Trace.trace((String)TRACE_MASKF, (Object)("Checking ACDL status on side = [" + string + "]."));
            localizableTextArray = this.frameProvider.getACDLStatus(string);
            object = (Short)localizableTextArray.get("ReturnCode");
            if (!((Short)object).equals(s)) {
                Short s5 = (Short)localizableTextArray.get("ErrorData");
                LocalizableText[] localizableTextArray2 = new LocalizableText[]{new LocalizableText(this.mtms)};
                PIUpdateException pIUpdateException = new PIUpdateException(-1775, "Get ACDL status for BPA " + this.mtms + " failed, ReturnCode=" + object + " ErrorData=" + s5, localizableTextArray2);
                throw pIUpdateException;
            }
            Short s6 = (Short)localizableTextArray.get("SystemStatusMode");
            Short s7 = (Short)localizableTextArray.get("SystemStatusProgress");
            Trace.trace((String)TRACE_MASKF, (Object)("nMode for [" + string + "] is " + s6));
            if (!s6.equals(s)) {
                bl2 = false;
                if (!(s7.equals(s2) || s7.equals(s3) || s7.equals(s4))) {
                    bl3 = false;
                }
            }
        }
        catch (PIHscClientException pIHscClientException) {
            LocalizableText[] localizableTextArray3 = new LocalizableText[]{new LocalizableText(this.mtms)};
            PIUpdateException pIUpdateException = new PIUpdateException(-1776, pIHscClientException, localizableTextArray3);
            throw pIUpdateException;
        }
        if (bl2) {
            n = 1;
            if (bl) {
                localizableTextArray = new LocalizableText[]{new LocalizableText(this.mtms)};
                object = new PIUpdateException(-1774, "BPA " + this.mtms + " is N mode power.", localizableTextArray);
                throw object;
            }
        } else if (bl3) {
            n = 2;
            if (bl) {
                localizableTextArray = new LocalizableText[]{new LocalizableText(this.mtms)};
                object = new PIUpdateException(-1773, "BPA " + this.mtms + " has ACDL pending.", localizableTextArray);
                throw object;
            }
        } else {
            n = 0;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<> isNModePower() returns " + n));
        return n;
    }

    public boolean isRedundant(PIUpdatesOwner pIUpdatesOwner) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isRedundant()");
        boolean bl = false;
        if (this.isForBpa()) {
            if (this.isBpaFspRedundant()) {
                bl = true;
            }
        } else if (pIUpdatesOwner.doesCECHaveSlaveFSP()) {
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isRedundant() returns " + (bl ? "true" : "false")));
        return bl;
    }

    public Hashtable openPhypFile(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) throws PIHscClientException {
        return this.beanProvider.openPhypFile(string, vector, vector2, vector3, vector4, vector5, vector6);
    }

    public void powerOff() throws PIHscClientException {
        this.beanProvider.powerOff();
    }

    public void powerOn() throws PIHscClientException {
        this.beanProvider.powerOn();
    }

    public void processACDL(PIUpdater pIUpdater) throws PIUpdateException {
        this.processACDL(1, pIUpdater);
        if (this.doesFrameFSPHaveSlave) {
            this.processACDL(2, pIUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processACDL(int n, PIUpdater pIUpdater) throws PIUpdateException {
        boolean bl;
        Trace.trace((String)TRACE_MASKT, (Object)"-> processACDL()");
        Short s = new Short(0);
        this.currentUpdater = pIUpdater;
        this.acdlPhase = new Integer(n);
        this.heHandler.addSubscription(305, "IBMHSC_Frame");
        this.waitForAcdlDone();
        String string = this.getBpaSide("master");
        if (n == 2) {
            string = this.getBpaSide("slave");
        }
        Trace.trace((String)TRACE_MASKD, (Object)"Entering synchronized block");
        Integer n2 = this.acdlLock;
        synchronized (n2) {
            try {
                this.acdlSide = string;
                this.runningAcdl = true;
                this.checkFrusDone();
                this.acdlReturnCode = this.acdlNotDone;
                Trace.trace((String)TRACE_MASKD, (Object)"Calling startACDL");
                Hashtable hashtable = this.frameProvider.startACDL(string);
                Short s2 = (Short)hashtable.get("ReturnCode");
                Trace.trace((String)TRACE_MASKD, (Object)("startACDL completed returnCode=" + s2));
                if (!s2.equals(s)) {
                    Short s3 = (Short)hashtable.get("ErrorData");
                    PIUpdateException pIUpdateException = new PIUpdateException(-1771, "Start ACDL for BPA " + this.mtms + " failed, ReturnCode=" + s2 + " ErrorData=" + s3);
                }
            }
            catch (Exception exception) {
                PIUpdateException pIUpdateException = new PIUpdateException(-1772, exception);
                throw pIUpdateException;
            }
            try {
                int n3 = 7 * this.frusToLoad;
                Trace.trace((String)TRACE_MASKD, (Object)("Waiting " + n3 + " minutes for ACDL to complete."));
                this.acdlLock.wait(n3 * 60000);
                Trace.trace((String)TRACE_MASKD, (Object)"ACDL has completed.");
            }
            catch (InterruptedException interruptedException) {
                Trace.trace((String)TRACE_MASKF, (Object)("Caught InterruptedException" + interruptedException));
            }
        }
        this.runningAcdl = false;
        if (this.acdlReturnCode.equals(this.acdlNotDone) && !(bl = this.checkFrusDone())) {
            PIUpdateException pIUpdateException = new PIUpdateException(-1768, "ACDL timed out.");
            throw pIUpdateException;
        }
        if (this.acdlReturnCode.equals(this.acdlFailed)) {
            boolean bl2 = this.checkFrusDone();
            PIUpdateException pIUpdateException = new PIUpdateException(-1767, "ACDL has failed.");
            throw pIUpdateException;
        }
        try {
            this.commitCodeUpdate(string, (short)1);
        }
        catch (PIHscClientException pIHscClientException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Failed while copying code from the T side to the P side.");
            PIUpdateException pIUpdateException = new PIUpdateException(-1764, pIHscClientException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- processACDL()");
    }

    public void readLID(String string, Vector vector, Vector vector2) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.readLID(string, vector, vector2);
    }

    public void readSpecialLID(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.readSpecialLID(string, vector, vector2, vector3, vector4, vector5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebootServiceProcessor(String string) throws HException {
        Object object;
        Trace.trace((String)TRACE_MASKT, (Object)"-> rebootServiceProcessor()");
        boolean bl = false;
        Trace.trace((String)TRACE_MASKD, (Object)("fspTarget=[" + string + "]"));
        if (string.equals("slave")) {
            bl = true;
            Trace.trace((String)TRACE_MASKD, (Object)"runningSlave has been set.");
        }
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.rebootDone = false;
        try {
            this.cecProvider.rebootServiceProcessor(string);
        }
        catch (PIHscClientException pIHscClientException) {
            object = pIHscClientException.getHscExId();
            if (((String)object).equals("1400")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Timeout from rebootServiceProcessor is OK.");
            }
            PIUpdateException pIUpdateException = new PIUpdateException(-1980, pIHscClientException);
            throw pIUpdateException;
        }
        int n = 20;
        object = new File("/opt/ccfw/data/RebootTime");
        if (((File)object).exists()) {
            try {
                n = 4 * PIUpdatesOwner.readFileIntoInteger((File)object);
            }
            catch (Throwable throwable) {
                Trace.trace((String)TRACE_MASKF, (Object)("Using default maxWaitTime " + n + " Caught Throwable" + throwable));
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)("runningSlave is " + (bl ? "true" : "false")));
        if ((bl || this.isForBpa() && this.isBpaFspRedundant()) && !this.connectionObjectSubscription) {
            Trace.trace((String)TRACE_MASKF, (Object)"Starting a subscription to connection changes.");
            this.heHandler.addSubscription(4, "IBMHSC_Connection");
            this.connectionObjectSubscription = true;
        }
        Trace.trace((String)TRACE_MASKF, (Object)("runningSlave is " + (bl ? "true" : "false")));
        if (bl) {
            Integer n2 = this.backupRebootLock;
            synchronized (n2) {
                try {
                    Trace.trace((String)TRACE_MASKD, (Object)("Wait has started for backup maxWaitTime=" + n));
                    this.waitingOnBackup = true;
                    this.backupDisconnected = false;
                    this.backupRebootLock.wait(n * 60000);
                    this.waitingOnBackup = false;
                    Trace.trace((String)TRACE_MASKD, (Object)"Wait completed.");
                    if (!this.rebootDone) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Wait for backup FSP has timed out.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Wait for reboot interrupted.");
                }
            }
        }
        Integer n3 = this.rebootLock;
        synchronized (n3) {
            try {
                Trace.trace((String)TRACE_MASKF, (Object)("Wait has started for primary maxWaitTime=" + n));
                this.waitingOnPrimary = true;
                this.primaryDisconnected = false;
                this.rebootLock.wait(n * 60000);
                this.waitingOnPrimary = false;
                Trace.trace((String)TRACE_MASKF, (Object)"Wait completed.");
                if (!this.rebootDone) {
                    UnsignedInt8 unsignedInt8 = new UnsignedInt8(254);
                    UnsignedInt8 unsignedInt82 = this.getState();
                    if (unsignedInt82.equals((Object)unsignedInt8)) {
                        PIUpdateException pIUpdateException = new PIUpdateException(-1915, "rebootServiceProcessor never took the FSP out of a noconnect state.");
                        throw pIUpdateException;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.trace((String)TRACE_MASKF, (Object)"Wait for reboot interrupted.");
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- rebootServiceProcessor()");
    }

    public void reIPL() throws PIHscClientException {
        this.beanProvider.reIPL();
    }

    public void setCodeUpdateOwner(String string, short s) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.setCodeUpdateOwner(string, s);
    }

    public void startCodeUpdate(String string, short s, int n) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.startCodeUpdate(string, s, n);
    }

    public Vector startFirmwareUpdate(String string, short s, int n) throws PIHscClientException {
        return this.beanProvider.startFirmwareUpdate(string, s, n);
    }

    public void writeLID(String string, Vector vector, Vector vector2) throws PIHscClientException {
        if (this.fspForBpa) {
            string = this.getBpaSide(string);
        }
        this.cecProvider.writeLID(string, vector, vector2);
    }

    private boolean areFrusDone(Hashtable hashtable) throws PIUpdateException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> areFrusDone()");
        Short s = new Short(0);
        Short s2 = new Short(3);
        Short s3 = new Short(0);
        Short s4 = new Short(1);
        boolean bl = false;
        Short s5 = (Short)hashtable.get("NoOfFRUCompleted");
        Short s6 = (Short)hashtable.get("NoOfFRUToLoad");
        Short s7 = (Short)hashtable.get("SystemStatusProgress");
        this.frusToLoad = s6.intValue();
        if (this.frusToLoad == 0) {
            this.frusToLoad = 2;
        }
        Trace.trace((String)TRACE_MASKF, (Object)("completed=" + s5 + " toLoad=" + s6 + " statusProgress=" + s7));
        UpdaterEvent updaterEvent = new UpdaterEvent((Updater)this.currentUpdater);
        Object[] objectArray = new LocalizableText[]{new LocalizableText(s5.toString()), new LocalizableText(s6.toString()), new LocalizableText(this.acdlPhase.toString()), new LocalizableText(this.mtms)};
        MessageText messageText = new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD0039", objectArray);
        Trace.trace((String)TRACE_MASKD, (Object)("message=[" + messageText + "]"));
        updaterEvent.setMessage((LocalizableText)messageText);
        this.currentUpdater.acdlFireMessage(updaterEvent);
        if (s7.equals(s3) || s7.equals(s4)) {
            bl = true;
        }
        if (s7.equals(s2)) {
            bl = true;
            this.acdlReturnCode = this.acdlFailed;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- areFrusDone() returns " + bl));
        return bl;
    }

    private boolean checkFrusDone() throws PIUpdateException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> checkFrusDone()");
        Hashtable hashtable = this.getAcdlStatus(this.acdlSide);
        boolean bl = this.areFrusDone(hashtable);
        Trace.trace((String)TRACE_MASKT, (Object)("<- checkFrusDone() returns " + bl));
        return bl;
    }

    private Hashtable getAcdlStatus(String string) throws PIUpdateException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getAcdlStatus()");
        Short s = new Short(0);
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = this.frameProvider.getACDLStatus(string);
            Short s2 = (Short)hashtable.get("ReturnCode");
            if (!s2.equals(s)) {
                Short s3 = (Short)hashtable.get("ErrorData");
                PIUpdateException pIUpdateException = new PIUpdateException(-1769, "Get ACDL status for BPA " + this.mtms + " failed, ReturnCode=" + s2 + " ErrorData=" + s3);
                throw pIUpdateException;
            }
        }
        catch (PIHscClientException pIHscClientException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Got exception trying to read status after ACDL asynch.");
            PIUpdateException pIUpdateException = new PIUpdateException(-1770, pIHscClientException);
            throw pIUpdateException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- getAcdlStatus()");
        return hashtable;
    }

    private void initTargettedFsp(String string, boolean bl) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> initTargettedFsp() for MTMS [" + string + "]"));
        this.mtms = new String(string);
        String string2 = null;
        Object var4_4 = null;
        this.runningAcdl = false;
        this.connectionObjectSubscription = false;
        this.waitingOnBackup = false;
        this.waitingOnPrimary = false;
        this.backupDisconnected = false;
        this.primaryDisconnected = false;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Failed attempting to get host name " + exception));
            PIUpdateException pIUpdateException = new PIUpdateException(-2037, exception);
            throw pIUpdateException;
        }
        try {
            Trace.trace((String)TRACE_MASKF, (Object)("Host name = [" + string2 + "] mtms = [" + this.mtms + "]"));
            int n = 0;
            this.fspForBpa = false;
            if (!bl) {
                n = 1;
                this.fspForBpa = true;
            }
            this.cecProvider = PIHscSysCIMClient.createInstance(string2, this.mtms, true, n);
            this.beanProvider = PIHSCCECCIMClient.createInstance(string2, this.mtms, true);
            if (!bl) {
                Trace.trace((String)TRACE_MASKD, (Object)"Calling createInstance for frame FSP");
                this.frameProvider = PIHSCFrameCIMClient.createInstance(string2, this.mtms, true, "root/ibmhscS1_0");
                Trace.trace((String)TRACE_MASKD, (Object)"createInstance completed for frame FSP");
            }
        }
        catch (Throwable throwable) {
            Trace.trace((String)TRACE_MASKF, (Object)("Failed attempting to create FSP client " + throwable));
            LocalizableText[] localizableTextArray = new LocalizableText[]{new LocalizableText(this.mtms)};
            PIUpdateException pIUpdateException = new PIUpdateException(-2048, throwable, localizableTextArray);
            throw pIUpdateException;
        }
        Trace.trace((String)TRACE_MASKF, (Object)("this.cecProvider=" + this.cecProvider + " this.beanProvider=" + this.beanProvider + " this.frameProvider=" + this.frameProvider));
        Hashtable hashtable = new Hashtable();
        this.heHandler = PAHscEventHandler.buildHandler(this, hashtable);
        this.lastState = this.getState();
        if (this.fspForBpa) {
            this.heHandler.addSubscription(4, "IBMHSC_Frame");
        } else {
            this.heHandler.addSubscription(4, "IBMHSC_ComputerSystem");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- initTargettedFSP()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAcdlDone() {
        Short s;
        Short s2;
        Hashtable hashtable;
        Serializable serializable;
        Trace.trace((String)TRACE_MASKT, (Object)"-> waitForAcdlDone()");
        boolean bl = false;
        Short s3 = new Short(2);
        int n = 14;
        try {
            serializable = this.getAcdlStatus("SIDE_A");
            hashtable = this.getAcdlStatus("SIDE_B");
            s2 = (Short)serializable.get("NoOfFRUToLoad");
            s = (Short)serializable.get("SystemStatusProgress");
            Trace.trace((String)TRACE_MASKD, (Object)("toLoadonA=" + s2 + " statusProgressonA=" + s));
            Short s4 = (Short)hashtable.get("NoOfFRUToLoad");
            Short s5 = (Short)hashtable.get("SystemStatusProgress");
            Trace.trace((String)TRACE_MASKD, (Object)("toLoadonB=" + s4 + " statusProgressonB=" + s5));
            int n2 = 7 * s2.intValue();
            int n3 = 7 * s4.intValue();
            if (n2 > n) {
                n = n2;
            }
            if (n3 > n) {
                n = n2;
            }
            if (!s.equals(s3) && !s5.equals(s3)) {
                bl = true;
                Trace.trace((String)TRACE_MASKF, (Object)"ACDL is not in progress on either side.");
            }
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Got an exception on initial check for if ACDL is in progress");
        }
        while (n > 0 && !bl) {
            Trace.trace((String)TRACE_MASKD, (Object)("minutes=" + n));
            try {
                serializable = this.getAcdlStatus("SIDE_A");
                hashtable = this.getAcdlStatus("SIDE_B");
                s2 = (Short)serializable.get("SystemStatusProgress");
                Trace.trace((String)TRACE_MASKD, (Object)(" statusProgressonA=" + s2));
                s = (Short)hashtable.get("SystemStatusProgress");
                Trace.trace((String)TRACE_MASKD, (Object)(" statusProgressonB=" + s));
                if (!s2.equals(s3) && !s.equals(s3)) {
                    bl = true;
                    Trace.trace((String)TRACE_MASKF, (Object)"ACDL is not in progress on either side.");
                }
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKF, (Object)"Got an exception on check for if ACDL is in progress");
            }
            --n;
            serializable = this.acdlLock;
            synchronized (serializable) {
                try {
                    Trace.trace((String)TRACE_MASKD, (Object)"Wait time before next ACDL check.");
                    this.acdlLock.wait(60000L);
                    Trace.trace((String)TRACE_MASKD, (Object)"Ready to go check ACDL again.");
                }
                catch (InterruptedException interruptedException) {
                    Trace.trace((String)TRACE_MASKF, (Object)("Caught InterruptedException" + interruptedException));
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- waitForAcdlDone()");
    }
}

